function [trace_out_x, trace_out_y] = ShapeSimplify(trace, nb_points, kernel_size)
% This function Simplify the traces acquired using the gesture recognition
% module. It gets read of noisy points and interpolate the trace.
% trace is a X, Y column vector
% trace_out_x is a X column vector
% trace_out_y is a T column vector
% nb_points is the number of points wanted in trace_out
% kernel_size : size of the morphological filtering (small = precise but
% could miss some noise; big = less precise but the noise is surely deleted
% example >>load TOTAL.mat
%         >>[trace_out_x, trace_out_y] = ShapeSimplify(circ2, 40, 5);

%tic
I=[]; %Image initialization
fin = size(trace,1);

for i=1:(fin-1)
    I = logical(func_DrawLine(logical(I), round(trace(i,1)+1), round(trace(i,2)+1), round(trace(i+1,1)+1), round(trace(i+1,2)+1), 1)); %put the trace into the image
end
II = logical(func_DrawLine(logical(I), round(trace(fin,1)+1), round(trace(fin,2)+1), round(trace(1,1)+1), round(trace(1,2)+1), 1)); %close the last point with the first one

aa=(imfill(logical(I),'holes')); %fill I
aaa=(imfill(logical(II),'holes')); %fill II

% here we compare the areas of aa and aaa to see if we have or not to close
% the figure
if sum(sum(aa))<(sum(sum(aaa))/3)
    aa=aaa;
end


clear II, aaa;

% here the image I is the filled image of the trace

init=regionprops(uint8(aa),'Image');
norm=init.Image;
taux=300/size(norm,1);
aa=imresize(logical(norm),taux);

% here aa is normalized and inside its bounding box

BX=regionprops(uint8(aa),'Centroid');
aa=imopen(logical(aa),strel('disk',kernel_size));
aa=bwlabel(logical(aa));
if max(max(aa))>1
   aa=bwselect(uint8(aa),BX.Centroid(1),BX.Centroid(2));
end

% here bb contains the filtered image without the noise


real_shape=max(trace(:,2))-min(trace(:,2));
real_taux=real_shape/size(aa,2);

aa=imresize(logical(aa),real_taux);

% here we get back to the real size

vignette2 = zeros(size(aa,1)+10,size(aa,2)+10);
vignette2(6:end-5,6:end-5)=aa;

clear aa;

% vignette2 contains a 5 pixels bigger image in order to have the contour
% inside the image


[x_coord,y_coord]=find(edge(vignette2,'sobel'));

x=x_coord;
y=y_coord;

xxx=x_coord;
yyy=y_coord;
%get the points ON

% the two loops get the ON points in the good order to be ploted  
yy=diff(y);
for i=1:(size(x,1)-1);
    if yy(i)==0
        x(i)=0;
        y(i)=0;
    end
end
x(x==0)=[];
y(y==0)=[];


yyyy=[1 ; yy];
for i=1:(size(xxx,1)-1);
    if yyyy(i)==0
        xxx(i)=0;
        yyy(i)=0;
    end
end

xxx(xxx==0)=[];
yyy(yyy==0)=[];
Y=[yyy ;flipud(y)];Y(end+1)=Y(1);Y=Y+min(trace(:,2));
X=[xxx;flipud(x)];X(end+1)=X(1);X=X+min(trace(:,1));

%Here oui interpolate in order to keep the number of points specified
%(nb_poins)

XX=interp1(1:length(X) ,X, 1: round(length(X)/nb_points) :length(X),'spline');
YY=interp1(1:length(Y) ,Y, 1: round(length(Y)/nb_points) :length(Y),'spline');

% final result
trace_out_x = XX';
trace_out_y = YY';
%toc

%trace_out = [XX' YY'];
figure,plot(trace(:,1),trace(:,2)),title('Before ...');
figure,plot(trace_out_x,trace_out_y),title('After ...');